package magazzino.utils;

import java.util.ArrayList;
import java.util.List;

import java.util.StringTokenizer;

public class Formatter implements IFormatter {
	List<String> stock;
	StringTokenizer tokenizer;

	private String vettura;
	private int[] quantities;
	private List<String> models = new ArrayList<String>();
	private int[] measures;
	private int[] days;

	public Formatter(List<String> stocks, String vettura) {
		this.stock = stocks;
		this.vettura = vettura;
		
		this.quantities = new int[stocks.size()];
		this.measures = new int[stocks.size()];
		this.days = new int[stocks.size()];
		
		for (int i = 0; i < stocks.size(); i++) {
			
			StringTokenizer tok = new StringTokenizer(stocks.get(i));

			this.quantities[i] = Integer.parseInt(tok.nextToken());

			String tmp = tok.nextToken();
			String[] tmps = tmp.split("\\(");
			models.add(tmps[0]);
			String[] tmps2 = tmps[1].split("\\)");
			this.measures[i] = Integer.parseInt(tmps2[0]);
			this.days[i] = Integer.parseInt(tok.nextToken());

	//			System.out.println(quantities[i] + " " + models.get(i) + " " + measures[i] + " "
	//					+ days[i]);
			
		}

	}

	@Override
	public int[] getQuantities() {
		return quantities;
	}

	@Override
	public List<String> getModels() {
		return models;
	}

	@Override
	public int[] getMeasures() {
		// TODO Auto-generated method stub
		return measures;
	}

	@Override
	public int[] getDays() {
		return days;
	}

	@Override
	public String getVettura() {
		return vettura;
	}
}
